<?php

namespace App\Modules\Ais\Models\Facility;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Position extends Model 
{

    protected $table = 'ais_facility_position';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('callsign', 'frequency', 'logon_order');

    public function facility()
    {
        return $this->belongsTo('App\Modules\Ais\Models\Facility');
    }

}